<?php
/*
 * Copyright 2015-present MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace MongoDB\Model;

use Iterator;
use ReturnTypeWillChange;

/**
 * IndexInfoIterator interface.
 *
 * This iterator is used for enumerating indexes in a collection.
 *
 * @api
 * @see \MongoDB\Collection::listIndexes()
 */
interface IndexInfoIterator extends Iterator
{
    /**
     * Return the current element as a IndexInfo instance.
     *
     * @return IndexInfo
     */
    #[ReturnTypeWillChange]
    public function current();
}
